API_VERSION = 'API_v1.0'

MOD_NAME = 'DamageMeter'

try:
    from API_v_1_0 import flash, battle, callbacks, events
except:
    pass

import Keys
from userprefs import UserPrefs
# setUserPref


# noinspection PyPep8Naming,PyUnusedLocal,PyMethodMayBeStatic,PyNoneFunctionAssignment
class DamageMeter:
    ENEMY_DAMAGED = 'DamageMeter.onEnemyDamaged'
    SELF_DAMAGED = 'DamageMeter.onSelfDamaged'
    CLEAN_DATA = 'DamageMeter.cleanData'

    def __init__(self):
        events.onSFMEvent(self.onSFMEvent)
        events.onReceiveShellInfo(self.onReceiveShellInfo)
        events.onBattleStart(self.onBattleStarted)
        events.onBattleQuit(self.onBattleQuit)

        flash.setUbMarkup("DamageMeter.xml", "DamageMeterMod.swf", "DamageMeter")

        self._userprefs = UserPrefs(MOD_NAME)

    def onReceiveShellInfo(self, victimID, shooterID, ammoId, matId, shotID, booleans, damage, shotPosition, yaw, hlinfo):
        # skip shots without damage
        if damage < 1:
            return
        
        victim = battle.getPlayerByVehicleId(victimID)
        shooter = battle.getPlayerByVehicleId(shooterID)
        player = battle.getSelfPlayerInfo()

        damage_info_player = shooter if player.shipId == victim.shipId else victim
        damage_info = self.__getDamageInfo(ammoId, damage, damage_info_player)

        # flash.call("Console.log", [player.shipId, victimID, shooterID])
        if player.shipId == victimID:
            flash.call(self.SELF_DAMAGED, [damage_info])
        elif player.shipId == shooterID:
            flash.call(self.ENEMY_DAMAGED, [damage_info])

    def __getDamageInfo(self, ammoId, damage, damage_info_player):
        """
        Get info about damage (will be sent to flash)
        :type ammoId: long
        :type damage: float
        :type damage_info_player: PlayerInfo.PlayerInfo
        :return:
        """
        data = self.__getFlashData(damage_info_player)
        data['ammoType'] = self.__getAmmoType(ammoId)
        data['damage'] = damage
        return data

    def __getFlashData(self, player):
        """
        Create dict with information about player.
        :type player: PlayerInfo.PlayerInfo
        :rtype: dict
        """
        info = dict(
            id=player.id,
            name=player.name,
            shipId=player.shipId,
            subtype=player.shipInfo.subtype,
            shipName=player.shipInfo.name,
            shipNation=player.shipInfo.nation,
            shipNameIDS=player.shipInfo.nameIDS,
            pathTinyIcon=player.shipInfo.pathTinyIcon,
        )
        return info

    def __getAmmoType(self, ammoId):
        """
        Get ammo type by ammo id
        :type ammoId: long
        :rtype: str
        """
        ammoInfo = battle.getAmmoParams(ammoId)
        ammoType = ammoInfo.ammoType
        return ammoType

    def onBattleStarted(self):
        # hack for replays
        flash.call("onMovieChanged", ['Battle'])

    def onBattleQuit(self, arg):
        """
        Called when player leaves battle. Clean damage info here.
        :return:
        """
        flash.call(self.CLEAN_DATA, [])

    def onSFMEvent(self, eventName, eventData):
        """
        :type eventName: str
        :type eventData: dict
        """
        flash.call("Console.log", [eventName, str(eventData)])
        if eventName in ['window.becomeTopInFlash', 'window.becomeTop', 'window.show']:
            flash.call("onMovieChanged", [eventData['windowName']])


g_damageMeter = DamageMeter()
