API_VERSION = 'API_v1.0'


class GameTypes:
    random          = 'RandomBattle'
    trainingRoom    = 'TrainingBattle'
    cooperative     = 'CooperativeBattle'
    ranked          = 'RankedBattle'
    introMission    = 'TutorialBattle'
    pve             = 'PVEBattle'
    clan            = 'ClanBattle'
    event           = 'EventBattle'


class SessionStatMod:

    def __init__(self):
        self.total_battles = 0
        self.win_battles = 0
        self.win_rate = 0
        self.total_damage = 0
        self.average_damage = 0
        self.kills = 0
        self.average_kills = 0
        self.exp = 0
        self.average_exp = 0
        self.free_exp = 0
        self.average_free_exp = 0
        self.creds = 0
        self.average_credits = 0
    
        flash.setUbMarkup("SessionStatMod.xml", "SessionStatMod.swf", "SessionStatMod")
        events.onSFMEvent(self.onSFMEvent)
        events.onBattleStatsReceived(self.onBattleStatsReceived)
        events.onMarkupLoaded(self.setStatDefault)
        events.onGotRibbon(self.onGotRibbon)

    def setStatDefault(self, elem):
        flash.setUbData({
                    'total_battles'    : self.total_battles,
                    'win_battles'       : self.win_battles,
                    'win_rate'          : self.win_rate,
                    'total_damage'      : self.total_damage,
                    'average_damage'    : self.average_damage,
                    'kills'             : self.kills,
                    'average_kills'     : self.average_kills,
                    'exp'               : self.exp,
                    'average_exp'       : self.average_exp,
                    'free_exp'          : self.free_exp,
                    'average_free_exp'  : self.average_free_exp,
                    'credits'           : self.creds,
                    'average_credits'   : self.average_credits,
                })

    def onSFMEvent(self, eventName, eventData):
        if eventName == 'window.show' and eventData['windowName'] == 'Dock':
            flash.setUbData({'btnState': 1})
        elif eventName == 'window.hide' and eventData['windowName'] == 'Dock':
            flash.setUbData({'btnState': 0})

    def onBattleStatsReceived(self, battle_result):
        if battle_result['battle_type'] != GameTypes.trainingRoom:
            self.total_battles += 1
            if battle_result['winner_team_id'] == battle_result['team_id']:
                self.win_battles += 1

            self.win_rate = self.win_battles * 100/self.total_battles
            self.total_damage += battle_result['damage_sum']
            self.average_damage = round(self.total_damage/self.total_battles)
            self.average_kills = self.kills / self.total_battles
            self.exp += battle_result['exp']
            self.average_exp = round(self.exp/self.total_battles)
            self.free_exp += round(battle_result['exp'] * 0.13)
            self.average_free_exp = round(self.free_exp / self.total_battles)
            self.creds += battle_result['credits']
            self.average_credits = round(self.creds / self.total_battles)

        flash.setUbData({
                    'total_battles'     : self.total_battles,
                    'win_battles'       : self.win_battles,
                    'win_rate'          : self.win_rate,
                    'total_damage'      : self.total_damage,
                    'average_damage'    : self.average_damage,
                    'kills'             : self.kills,
                    'average_kills'     : self.average_kills,
                    'exp'               : self.exp,
                    'average_exp'       : self.average_exp,
                    'free_exp'          : self.free_exp,
                    'average_free_exp'  : self.average_free_exp,
                    'credits'           : self.creds,
                    'average_credits'   : self.average_credits,
                })

    def onGotRibbon(self, ribbonId):
        if ribbonId == constants.RibbonsType.RIBBON_FRAG:
            self.kills += 1


session_stat_mod = SessionStatMod()
